unit MediaPlu;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, MPlayer, Menus, ComCtrls;

type
  TMediaFrm = class(TForm)
    MediaPlayer1: TMediaPlayer;
    btnMegnyitas: TButton;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    mnFajl: TMenuItem;
    mnuKilepes: TMenuItem;
    AllapotSor: TStatusBar;
    mnuMegnyitas: TMenuItem;
    mnuSeparator: TMenuItem;
    Timer1: TTimer;
    TrackBar1: TTrackBar;
    procedure btnMegnyitasClick(Sender: TObject);
    procedure mnuKilepesClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
  private
    procedure felirat;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MediaFrm: TMediaFrm;

implementation
{$R *.DFM}

procedure TMediaFrm.btnMegnyitasClick(Sender: TObject);
var
  ext, hibaStr: string;
begin
 // ha kivlasztottunk egy fjlt az Open prbeszdablakban
 if OpenDialog1.Execute then
  begin
    if MediaPlayer1.DeviceID<>0 then  // ha van megnyitott mdiaeszkz
     begin
       MediaPlayer1.Stop; // lejtszs lelltsa
       MediaPlayer1.Close;
     end;

    ext:= AnsiUpperCase(ExtractFileExt(OpenDialog1.FileName));

    if  not (StrPos(StrLower(PChar(OpenDialog1.Filter)), StrLower(PChar(ext))) = nil)
    then
     with MediaPlayer1 do
      begin
        if (ext='.MID') or (ext='.RMI') then // MIDI
           begin
              TimeFormat:=tfMilliseconds;
              DeviceType:=dtSequencer;
           end
         else DeviceType:=dtAutoSelect;  //automatikus csatornatpus-kivlaszts

        FileName:= OpenDialog1.FileName;
        try
          Open;   // a csatorna megnyitsa
        except
          hibaStr := 'Hibakd: ' + IntToStr(Error) + #13#10;
          MessageDlg(hibaStr + ErrorMessage, mtError, [mbOk], 0);
        end;

        Display:=Panel1; // kpernyterlet belltsa
        DisplayRect:=Rect(2,2,0,0);
        if (DisplayRect.Bottom-DisplayRect.Top)>(Panel1.Height-4) then
            DisplayRect:=Rect(2,2,Panel1.Width*((Panel1.Height-4) div (DisplayRect.Bottom-DisplayRect.Top)),Panel1.Height-2)
        else
         if (DisplayRect.Right-DisplayRect.Left)>(Panel1.Width-4) then
           DisplayRect:=Rect(2,2,Panel1.Width-2,Panel1.Height*((Panel1.Width-4) div (DisplayRect.Right-DisplayRect.Left)));
         Panel1.Repaint;

        // az llapotsor felirata:
        AllapotSor.Panels.Items[0].Text := OpenDialog1.FileName + '  lejtszsa';
      end
    else
      begin
        AllapotSor.Panels.Items[0].Text := 'Nincs betlttt mdiafjl.';
        AllapotSor.Panels.Items[1].Text := '';
        AllapotSor.Panels.Items[2].Text := '';
      end;
  end;
end;

procedure TMediaFrm.mnuKilepesClick(Sender: TObject);
begin
  Close;
end;

procedure TMediaFrm.Timer1Timer(Sender: TObject);
var
  perc, mperc : Longint;
begin
 // lejtszs vgnek figyelse
 if TrackBar1.Position=TrackBar1.Max
  then
    begin
     felirat;   // llapotsor frisstse
     Timer1.Enabled:=false;
     MediaPlayer1.Rewind;
     TrackBar1.Position:=0;
    end
  else
    // az idmutat frisstse, ill. csuszka elmozdtsa
    case MediaPlayer1.TimeFormat of
     tfMilliseconds:
       begin
         TrackBar1.Position := MediaPlayer1.Position;
         mperc:=MediaPlayer1.Position div 1000;
         perc:=mperc div 60;
         AllapotSor.Panels.Items[1].Text:=Format('%2d:%2d:%2d',[(perc div 60),(perc mod 60),(mperc mod 60)]);
       end;
     tfFrames:  // kpek
       begin
         TrackBar1.Position :=  MediaPlayer1.Position;
         AllapotSor.Panels.Items[1].Text:=IntToStr(TrackBar1.Position) + ' keret';
       end;
     tfHMS:
       MediaPlayer1.TimeFormat:=tfMilliseconds
     else
       begin
         TrackBar1.Position := MediaPlayer1.Position;
         AllapotSor.Panels.Items[1].Text:=IntToStr(MediaPlayer1.Position);
       end;
    end;
end;

procedure TMediaFrm.felirat();
var
  perc, mperc : Longint;
begin
 TrackBar1.Max := MediaPlayer1.Length;  // a skcsuszka vgllsi rtknek a megadsa
 case MediaPlayer1.TimeFormat of
   tfMilliseconds:
     begin
       mperc:=MediaPlayer1.Length div 1000;
       perc:=mperc div 60;
       // a mdiafjl hossznak kirsa:
       AllapotSor.Panels.Items[2].Text:=Format('%2d:%2d:%2d',[(perc div 60),(perc mod 60),(mperc mod 60)]);
     end;
   tfFrames:  // kpek
     AllapotSor.Panels.Items[2].Text:=IntToStr(MediaPlayer1.Length) + ' keret'; //hossz
   tfHMS:
     MediaPlayer1.TimeFormat:=tfMilliseconds
   else
     AllapotSor.Panels.Items[2].Text:=IntToStr(MediaPlayer1.Length);
 end;
end;

procedure TMediaFrm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if MediaPlayer1.DeviceID<>0 then
   begin
    MediaPlayer1.Stop;
    MediaPlayer1.Close;
   end;
end;

procedure TMediaFrm.MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
 felirat;  // llapotsor frisstse
 case Button of
   btPlay:  // ha a Play gombra kattintottunk
    begin
      // az idmutat frissitsnek gyakorsga
      Timer1.Interval:=(TrackBar1.Max div TrackBar1.Width)+1;
      Timer1.Enabled:=true;

      with MediaPlayer1 do
       begin
         Display:=Panel1; // kpernyterlet belltsa
         DisplayRect:=Rect(2,2,0,0);
         if (DisplayRect.Bottom-DisplayRect.Top)>(Panel1.Height-4) then
           DisplayRect:=Rect(2,2,Panel1.Width*((Panel1.Height-4) div (DisplayRect.Bottom-DisplayRect.Top)),Panel1.Height-2)
         else
         if (DisplayRect.Right-DisplayRect.Left)>(Panel1.Width-4) then
           DisplayRect:=Rect(2,2,Panel1.Width-2,Panel1.Height*((Panel1.Width-4) div (DisplayRect.Right-DisplayRect.Left)));
         Panel1.Repaint;
       end;
    end;

   btStop:
    if TrackBar1.Position=0 then MediaPlayer1.Position:=0;
  end;
end;

end.
